/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.dictionaries.furniture;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureCategory;

@Singleton
public class FurnitureCategoryDictionary {
    private Map<String, FurnitureCategory> byName = new HashMap<String, FurnitureCategory>();
    public static FurnitureCategory NULL_CATEGORY = new FurnitureCategory();

    @Inject
    public FurnitureCategoryDictionary() throws IOException {
        this(new File("assets/definitions/furnitureCategories.json"));
    }

    public FurnitureCategoryDictionary(File categoriesJsonFile) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        List categories = (List)objectMapper.readValue(FileUtils.readFileToString(categoriesJsonFile, "UTF-8"), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, FurnitureCategory.class));
        for (FurnitureCategory furnitureCategory : categories) {
            this.byName.put(furnitureCategory.getName(), furnitureCategory);
        }
        this.byName.put(NULL_CATEGORY.getName(), NULL_CATEGORY);
    }

    public FurnitureCategory getByName(String name) {
        return this.byName.get(name);
    }

    public Collection<FurnitureCategory> getAll() {
        return this.byName.values();
    }

    static {
        NULL_CATEGORY.setName("Null category");
    }
}

